<?php

/*
* @category    360Dialog - WhatsApp Class
* @package     Nube Apps
* @author      Jorge Ancizar Galeano Ruiz<jorgegaleano@nubeapps.com.co>
* @copyright   2021 Jorge Ancizar Galeano Ruiz
* @version     Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   573168345866
*/

require("../../../core/php/_database.php");
session_start();

define( "NOMIPSCHAT","*MEDICARE IPS*");
define( "MSJPIERECUERDACANCELA","*_\"Si por cualquier motivo NO puedes asistir, recuerda que puedes CANCELAR esta cita hasta !UN(1) DIA ANTES DE LA FECHA PROGRAMADA¡ y así ayudas a que otro paciente pueda usar este espacio y no se pierda.\"_*");
define( "MSJPIEFELICITACANCELA","*_\"GRACIAS por cancelar tu cita a tiempo, así ayudas a que otro paciente pueda usar este espacio y no se pierda.\"_*");


class DIALOG360{
    private $API_URL;
    private $API_WEBHOOK;
    private $URL_WEBHOOK;
    private $API_TOKEN;
    private $API_HEADER;
    
    public $PROCESSS_STATE;
    public $idWSPOFI;
    public $response_api;
    public $input_request;
    
    public $type_obj;
    public $isMessage = "false";
    public $isContext = "false";
    public $isText = "false";
    public $isVideo = "false";
    public $isImage = "false";
    public $isDocument = "false";
    public $from_id;
    public $transaction_id;
    public $context_from_id;
    public $context_transaction_id;
    public $timestamp_mov;
    public $type_id;
    public $media_id;
    public $media_mime_type;
    public $media_sha256;
    public $media_caption;
    public $media_filename;
    public $answer;
    public $profile_name;
    public $wsp_id;
    
    public $recipient_id;
    public $status_id;
    public $question;
    public $contact;
    public $to_id;
    
    public $Paciente;
    public $Cliente;
    public $CAS;
    public $FechaAct;
    public $isBeginChat = "false";
    public $idchat_question;
    public $txtBodyToSend;
    public $rootId;
    public $questionMsg;
    public $questionMsgRpt;
    public $questionOpt;
    public $questionNextRoot;
    public $txtQuestionOpt;
    public $typeAnswer;
    public $questionTxt;
    public $questionTxtRpt;
    public $isChild;
    public $questionTimestamp;
    
    public $patientDocument;
    public $patientName;
    public $patientFirstName;
    public $patientToId;
    public $Genero;
    public $FecNac;
    public $WSPValido;
    public $Exento;
    public $patientCliente;
    public $patientEstado;
    public $patientExisteBD;
    public $patientBeginChat;
    
    public $tipoCita;
    public $idProced;
    public $codCUPS;
    public $descCUPS;
	
	public $appointmentCAS;
	public $appointmentDate;
	public $appointmentHour;
	public $appointmentDay;
	public $appointmentProfesional;
	public $appointmentConcept;
	public $isAbsence = 0;
	public $isAppointmentExists = 0;
	
    public $seloptionId = 0;
    public $seloptionTitle = "";
    public $seloptionFunction = "";
    public $seloptionNextRoot = "";
	
    public $isEndProcess = "false";
	
    public function __construct(){
        $gBaseDatos = new ofiMySQLi();
        $qry = "CALL sp_360dialog_get_paramsconnect()";
        $gBaseDatos->conectar();
        $paramFields = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->API_URL = $paramFields[0];
        $this->API_WEBHOOK = $paramFields[2];
        $this->API_TOKEN = $paramFields[1];
        $this->URL_WEBHOOK = array(
            'url' => '$paramFields[3]'
        );
        $this->API_HEADER = array(
            "Content-Type: application/json",
            "D360-Api-Key: $this->API_TOKEN",
        );
    }

    function getAuthentication(){
        $payload = json_encode($this->URL_WEBHOOK);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->API_WEBHOOK,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $this->API_HEADER,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $this->PROCESSS_STATE = 0;
            $responseAPI = $err;
        } else {
            $this->PROCESSS_STATE = 1;
            $responseAPI = $response;
        }
        return $responseAPI;
    }
    
    function prepareInputRequest(){
        $jsonIterator = new RecursiveIteratorIterator(
        new RecursiveArrayIterator(json_decode($this->input_request, TRUE)),
        RecursiveIteratorIterator::SELF_FIRST);
        $Root = "";
        $Context = "0";
        $item = 0;
        foreach ($jsonIterator as $key => $val) {
            if(is_array($val)) {
                if($key != "0"){
                    if($key == "messages"){
                        $this->type_obj = "messages";
                        $this->isMessage = "true";
                    }else if($key == "context"){
                        $this->isContext = "true";
                        $Context = "1";
                    }else if($key == "video"){
                        $this->isVideo = "true";
                    }else if($key == "image"){
                        $this->isImage = "true";
                    }else if($key == "document"){
                        $this->isDocument = "true";
                    }else if($key == "text"){
                        $this->isText = "true";
                    }else if($key == "statuses"){
                        $this->type_obj = "statuses";
                        $this->isMessage = "true";    
                    }
                    $Root = $key;
                }
            } else {
                if($Root == "context"){
                    if($key == "from" && $item == 3){
                        $this->context_from_id = $val;
                    }else if($key == "id" && $item == 4){
                        $this->context_transaction_id = $val;
                    }
                }else if($Root == "video"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }else if($Root == "image"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }else if($Root == "document"){
                    if($key == "id"){
                        $this->media_id = $val;
                    }
                }
                if($key == "from"){
                    $this->from_id = $val;
                }else if($key == "id"){
                    $this->transaction_id = $val;
                }else if($key == "body"){
                    $this->answer = $val;
                }else if($key == "timestamp"){
                    $this->timestamp_mov = $val;
                }else if($key == "type"){
                    $this->type_id = $val;
                }else if($key == "type"){
                    $this->type_id = $val;
                }else if($key == "name"){
                    $this->profile_name = $val;
                }else if($key == "wa_id"){
                    $this->wsp_id = $val;
                }else if($key == "mime_type"){
                    $this->media_mime_type = $val;
                }else if($key == "sha256"){
                    $this->media_sha256 = $val;
                }else if($key == "caption"){
                    $this->media_caption = $val;
                }else if($key == "filename"){
                    $this->media_filename = $val;
                }else if($key == "recipient_id"){
                    $this->recipient_id = $val;
                    $this->wsp_id = $val;
                }else if($key == "status"){
                    $this->status_id = $val;
                }
            }
            $item++;
        }
        $this->saveJson();
    }
    
    function saveJson(){
        if($this->type_obj == "messages"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = 'CALL sp_360dialog_save_messages("' . $this->response_api . '","' . $this->type_obj . '","' . $this->isMessage . '","' . $this->isContext . '","' . $this->isText . '","' . $this->isVideo . '","' . $this->isImage . '","' . $this->isDocument . '","' . $this->from_id . '","' . $this->transaction_id . '","' . $this->context_from_id . '","' . $this->context_transaction_id . '","' . $this->timestamp_mov . '","' . $this->type_id . '","' . $this->media_id . '","' . $this->media_mime_type . '","' . $this->media_sha256 . '","' . $this->media_caption . '","' . $this->media_filename . '","' . $this->answer . '","' . $this->profile_name . '","' . $this->wsp_id . '","' . $this->recipient_id . '","' . $this->status_id . '","' . $this->question . '","' . $this->contact . '","' . $this->to_id . '","' . $this->Paciente . '","' . $this->Cliente . '","' . $this->CAS . '","' . $this->FechaAct . '","' . $this->isBeginChat . '","' . $this->idchat_question . '")';
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }else if($this->type_obj == "statuses"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = 'CALL sp_360dialog_save_statuses("' . $this->response_api . '","' . $this->type_obj . '","' . $this->isMessage . '","' . $this->transaction_id . '","' . $this->timestamp_mov . '","' . $this->status_id . '","' . $this->wsp_id . '","' . $this->recipient_id . '")';
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();    
        }else{
            $file = fopen("log.txt", "a");
            fwrite($file, $this->response_api . PHP_EOL);
            fwrite($file, "----------------------------------------------" . PHP_EOL);
            fclose($file);
        }
    }
    
    function sendMsg(){
        $numCel = $this->wsp_id;
        $data = array(
            "to" => "$numCel",
            "type" => "text",
            "text" => array (
                "body" => $this->txtBodyToSend
            )
        );
        $payload = json_encode($data);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->API_URL,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => $this->API_HEADER,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $this->PROCESSS_STATE = 0;
            $responseAPI = $err;
        } else {
            $this->PROCESSS_STATE = 1;
            $responseAPI = $response;
        }
        return $responseAPI;
    }
    
    function endChat(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_360dialog_end_chat("' . $this->wsp_id . '")';
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();        
    }

    function webHook(){
        $authMsg = $this->getAuthentication();
        $this->prepareInputRequest();
        $this->isBeginChat = "false";
        $this->patientBeginChat = "0";
        $this->rootId = "0";
        if($this->type_obj == "messages"){
            $this->validateAnswer();
            //Validar Chat 1 Vez
            $this->validateBeginChat();
            if($this->isBeginChat == "true"){
                //Mensaje Inicial
                $this->rootId = "0";
                $this->callMenuOptions("N");
                $this->sendQuestion();
            }else{
                if($this->answer != "{success:false}" && $this->answer != "" && $this->patientBeginChat != "1"){
                    $this->goFlowProcess();    
                }
            }
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////
    //GET METHOD
    ////////////////////////////////////////////////////////////////////////////////////
    function getCitasMedicina(){
        //validate that not have current appointments or absences
        $this->validateAbsence();
        if($this->isAbsence == 1){
            $this->showAbsence();
        }else{
            $this->validateAppointmentExists("%CONS%MEDIC%GENER%");
            if($this->isAppointmentExists == 1){
                $this->showAppointment("SI");
            }else{
                $this->getDateAppointmentMG();
            }
        }
    }
    
    function getCitasOdontologia(){
        $this->txtBodyToSend = $this->patientFirstName  . ", selecciona una de las siguientes opciones de citas de *ODONTOLOGIA GENERAL*" .  PHP_EOL .  PHP_EOL . "- Listado Odontologia General.";
        $this->sendMsg();        
    }
    
    function getCitasInterna(){
        $this->txtBodyToSend = $this->patientFirstName  . ", selecciona una de las siguientes opciones de citas de *MEDICINA INTERNA*" .  PHP_EOL .  PHP_EOL . "- Listado Medicina Interna.";
        $this->sendMsg();        
    }
    
    function getDateAppointmentMG(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_listcitasdisponiblexpac('" . $this->Paciente + 900 . "',\"" . $this->wsp_id . "\")";
        $this->writeLog($qry);
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($row);
        $this->txtQuestionOpt = '_x_echo _y_botOptions  = array(';
        $botQuestion = $this->patientFirstName . ", selecciona la cita que deseas *ASIGNAR*?" . PHP_EOL . PHP_EOL;
        $this->questionTxt = '_x_echo _y_botQuestion = _y_this->patientFirstName . \', selecciona la cita que deseas *ASIGNAR*?\' . PHP_EOL . PHP_EOL . ';
        $this->questionTxtRpt = '_x_echo $botQuestionRpt = \'Selecciona una de las siguientes citas para *ASIGNAR*:\' . PHP_EOL . PHP_EOL . ';
        $botOptions  = array();
        $item = "";
        $itemTxt = "";
        $control = "0";
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["citaID"] != ""){
                $control = "1";
                $itemTxt .= '\'' . ($i+1) . '\' => array(\'opcion\' => \'' . ($i+1) . '\',\'titulo\' => \'CAS: ' . $row[$i]["citaID"] . '\',\'funcion\' => \'setDateAppointment\',\'next\' => \'\',\'CAS\' => \'' . $row[$i]["citaID"] . '\'),';
                $numreg = "";
                $numreg = "'" . ($i+1) . "'";
                $titulo = "";
                $titulo = "'CAS " . $row[$i]["citaID"] . "'";
                $cas = "";
                $cas = "'" . $row[$i]["citaID"] . "'";
                $item = array($numreg => array('opcion' => $numreg,'titulo' => $titulo,'funcion' => 'setDateAppointment','next' => '','CAS' => $cas));
                array_push($botOptions, $item);
                
                $botQuestion .= '*' . ($i+1) . '*. ' . PHP_EOL;
                $botQuestion .= '  -  *Fecha*: ' . $row[$i]["fecAgenda"] . '- *Hora*: ' . $row[$i]["citaDescripcion"] . PHP_EOL;
                $botQuestion .= '  -  *Profesional*: ' . $row[$i]["Descripcion"] . PHP_EOL;
                //$botQuestion .= '  -  *Concepto*: ' . $row[$i]["Descripcion"] . PHP_EOL . PHP_EOL;
                $botQuestion .= '  -  *Concepto*: CONSULTA MEDICINA GENERAL' . PHP_EOL . PHP_EOL;

                $this->questionTxt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Fecha*: ' . $row[$i]["fecAgenda"] . ' - *Hora*: ' . $row[$i]["citaDescripcion"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Profesional*: ' . $row[$i]["Descripcion"] . '\' . PHP_EOL . ';
                //$this->questionTxt .= '\'  -  *Concepto*: ' . $row[$i]["Descripcion"] . '\' . PHP_EOL . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Concepto*: CONSULTA MEDICINA GENERAL\' . PHP_EOL . PHP_EOL . ';
                
                $this->questionTxtRpt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Fecha*: ' . $row[$i]["fecAgenda"] . ' - *Hora*: ' . $row[$i]["citaDescripcion"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Profesional*: ' . $row[$i]["Descripcion"] . '\' . PHP_EOL . ';
                //$this->questionTxtRpt .= '\'  -  *Concepto*: ' . $row[$i]["Descripcion"] . '\' . PHP_EOL . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Concepto*: CONSULTA MEDICINA GENERAL\' . PHP_EOL . PHP_EOL . ';
            }
        }
        $this->txtQuestionOpt .= substr($itemTxt, 0, (strlen($itemTxt)-1));
        $this->txtQuestionOpt .= ');';
        $botQuestion .= '*0. Salir*' . PHP_EOL . PHP_EOL . '*Escribe el numero de la opción que deseas*';
        $this->questionTxt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        $this->questionTxtRpt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        if($control == "1"){
            $this->questionMsg = $botQuestion;
            $this->questionOpt = $botOptions;
            $this->rootId = "1.1.1";
            $this->sendQuestion();
            $this->saveRootOptions();
        }else{
            $this->txtBodyToSend = $this->patientFirstName . ", Lamentablemente no encontramos citas disponibles en este momento, te invitamos a que lo intentes más tarde.";
            $this->sendMsg();
            $this->txtBodyToSend = "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();    
        }    
    }
    
    function getCancelAppointment(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_checkcitasxcancelar('" . $this->Paciente . "')";
        $this->writeLog($qry);
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($row);
        $this->txtQuestionOpt = '_x_echo _y_botOptions  = array(';
        $botQuestion = $this->patientFirstName . ", selecciona la cita que deseas *CANCELAR*?" . PHP_EOL . PHP_EOL;
        $this->questionTxt = '_x_echo _y_botQuestion = _y_this->patientFirstName . \', selecciona la cita que deseas *CANCELAR*?\' . PHP_EOL . PHP_EOL . ';
        $this->questionTxtRpt = '_x_echo $botQuestionRpt = \'Selecciona una de las siguientes citas para *CANCELAR*:\' . PHP_EOL . PHP_EOL . ';
        $botOptions  = array();
        $item = "";
        $itemTxt = "";
        $control = "0";
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["CAS"] != ""){
                $control = "1";
                $itemTxt .= '\'' . ($i+1) . '\' => array(\'opcion\' => \'' . ($i+1) . '\',\'titulo\' => \'CAS: ' . $row[$i]["CAS"] . '\',\'funcion\' => \'setCancelAppointment\',\'next\' => \'\',\'CAS\' => \'' . $row[$i]["CAS"] . '\'),';
                $numreg = "";
                $numreg = "'" . ($i+1) . "'";
                $titulo = "";
                $titulo = "'CAS " . $row[$i]["CAS"] . "'";
                $cas = "";
                $cas = "'" . $row[$i]["CAS"] . "'";
                $item = array($numreg => array('opcion' => $numreg,'titulo' => $titulo,'funcion' => 'setCancelAppointment','next' => '','CAS' => $cas));
                array_push($botOptions, $item);
                
                $botQuestion .= '*' . ($i+1) . '*. ' . PHP_EOL;
                $botQuestion .= '  -  *Fecha*: ' . $row[$i]["FechaCita"] . '- *Hora*: ' . $row[$i]["HoraAgenda"] . PHP_EOL;
                $botQuestion .= '  -  *Profesional*: ' . $row[$i]["Profesional"] . PHP_EOL;
                $botQuestion .= '  -  *Concepto*: ' . $row[$i]["Actividad"] . PHP_EOL;
                $botQuestion .= '  -  *CAS*: ' . $row[$i]["CAS"] . PHP_EOL . PHP_EOL;
                
                $this->questionTxt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Fecha*: ' . $row[$i]["FechaCita"] . ' - *Hora*: ' . $row[$i]["HoraAgenda"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Profesional*: ' . $row[$i]["Profesional"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Concepto*: ' . $row[$i]["Actividad"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *CAS*: ' . $row[$i]["CAS"] . '\' . PHP_EOL . PHP_EOL . ';
                
                $this->questionTxtRpt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Fecha*: ' . $row[$i]["FechaCita"] . ' - *Hora*: ' . $row[$i]["HoraAgenda"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Profesional*: ' . $row[$i]["Profesional"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Concepto*: ' . $row[$i]["Actividad"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *CAS*: ' . $row[$i]["CAS"] . '\' . PHP_EOL . PHP_EOL . ';
            }
        }
        $this->txtQuestionOpt .= substr($itemTxt, 0, (strlen($itemTxt)-1));
        $this->txtQuestionOpt .= ');';
        $botQuestion .= '*0. Salir*' . PHP_EOL . PHP_EOL . '*Escribe el numero de la opción que deseas*';
        $this->questionTxt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        $this->questionTxtRpt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        if($control == "1"){
            $this->questionMsg = $botQuestion;
            $this->questionOpt = $botOptions;
            $this->rootId = "3.1";
            $this->sendQuestion();
            $this->saveRootOptions();
        }else{
            $this->txtBodyToSend = $this->patientFirstName . ", No tienes citas pendientes por *CANCELAR*.";
            $this->sendMsg();
            $this->txtBodyToSend = "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();    
        }    
    }
    
    function getConfirmAppointment(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_checkcitaxconfirmar('" . $this->Paciente . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($row);
        $this->txtQuestionOpt = '_x_echo _y_botOptions  = array(';
        $botQuestion = $this->patientFirstName . ", selecciona la cita que deseas *CONFIRMAR*?" . PHP_EOL . PHP_EOL;
        $this->questionTxt = '_x_echo _y_botQuestion = _y_this->patientFirstName . \', selecciona la cita que deseas *CONFIRMAR*?\' . PHP_EOL . PHP_EOL . ';
        $this->questionTxtRpt = '_x_echo $botQuestionRpt = \'Selecciona una de las siguientes citas para *CONFIRMAR*:\' . PHP_EOL . PHP_EOL . ';
        $botOptions  = array();
        $item = "";
        $itemTxt = "";
        $control = "0";
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["CAS"] != ""){
                $control = "1";
                $itemTxt .= '\'' . ($i+1) . '\' => array(\'opcion\' => \'' . ($i+1) . '\',\'titulo\' => \'CAS: ' . $row[$i]["CAS"] . '\',\'funcion\' => \'setConfirmAppointment\',\'next\' => \'\',\'CAS\' => \'' . $row[$i]["CAS"] . '\'),';
                $numreg = "";
                $numreg = "'" . ($i+1) . "'";
                $titulo = "";
                $titulo = "'CAS " . $row[$i]["CAS"] . "'";
                $cas = "";
                $cas = "'" . $row[$i]["CAS"] . "'";
                $item = array($numreg => array('opcion' => $numreg,'titulo' => $titulo,'funcion' => 'setConfirmAppointment','next' => '','CAS' => $cas));
                array_push($botOptions, $item);
                
                $botQuestion .= '*' . ($i+1) . '*. ' . PHP_EOL;
                $botQuestion .= '  -  *Fecha*: ' . $row[$i]["FechaCita"] . '- *Hora*: ' . $row[$i]["DesImprime"] . PHP_EOL;
                $botQuestion .= '  -  *Profesional*: ' . $row[$i]["Profesional"] . PHP_EOL;
                $botQuestion .= '  -  *Concepto*: ' . $row[$i]["DesProced"] . PHP_EOL;
                $botQuestion .= '  -  *CAS*: ' . $row[$i]["CAS"] . PHP_EOL . PHP_EOL;
                
                $this->questionTxt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Fecha*: ' . $row[$i]["FechaCita"] . ' - *Hora*: ' . $row[$i]["DesImprime"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Profesional*: ' . $row[$i]["Profesional"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *Concepto*: ' . $row[$i]["DesProced"] . '\' . PHP_EOL . ';
                $this->questionTxt .= '\'  -  *CAS*: ' . $row[$i]["CAS"] . '\' . PHP_EOL . PHP_EOL . ';
                
                $this->questionTxtRpt .= '\'*' . ($i+1) . '*. \' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Fecha*: ' . $row[$i]["FechaCita"] . ' - *Hora*: ' . $row[$i]["DesImprime"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Profesional*: ' . $row[$i]["Profesional"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *Concepto*: ' . $row[$i]["DesProced"] . '\' . PHP_EOL . ';
                $this->questionTxtRpt .= '\'  -  *CAS*: ' . $row[$i]["CAS"] . '\' . PHP_EOL . PHP_EOL . ';
            }
        }
        $this->txtQuestionOpt .= substr($itemTxt, 0, (strlen($itemTxt)-1));
        $this->txtQuestionOpt .= ');';
        $botQuestion .= '*0. Salir*' . PHP_EOL . PHP_EOL . '*Escribe el numero de la opción que deseas*';
        $this->questionTxt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        $this->questionTxtRpt .= '\'*0. Salir*\' . PHP_EOL . PHP_EOL . \'*Escribe el numero de la opcion que deseas*\';';
        if($control == "1"){
            $this->questionMsg = $botQuestion;
            $this->questionOpt = $botOptions;
            $this->rootId = "2.1";
            $this->sendQuestion();
            $this->saveRootOptions();
        }else{
            $this->txtBodyToSend = $this->patientFirstName . ", No tienes citas pendientes por *CONFIRMAR*.";
            $this->sendMsg();
            $this->txtBodyToSend = "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();    
        }
    }
    
    function getLastQuestion(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_get_lastquestion("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($responseQry[0] != "" && $responseQry[0] != "null" && $responseQry[0] != null && $responseQry[0] != "{success:false}"){
            @eval($responseQry[1]);
            @eval($responseQry[2]);
            $this->questionMsg = $botQuestion;
            $this->questionOpt = $botOptions;
            $this->typeAnswer = $responseQry[3];
            $this->questionTxt = $responseQry[4];
            $this->questionTimestamp = $responseQry[6];
            $this->txtQuestionOpt = $responseQry[2];
            $this->rootId = $responseQry[0];
            if($this->rootId != "" && $this->rootId != null && $this->rootId != "{success:false}" && $this->rootId != "0"){
                $this->saveRootOptionsMasterId();
            }
        }
    }
    
    function getDataPatient(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_validate_patient("' . $this->answer . '","' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->Paciente = $responseQry[0];
        $this->patientDocument = $responseQry[1];
        //$this->patientName = $responseQry[2];
        $this->Genero = $responseQry[3];
        $this->patientToId = $responseQry[4];
	    $this->FecNac = $responseQry[5];
	    $this->WSPValido = $responseQry[7];
	    $this->patientName = "*";
	    if($responseQry[8] != "" && $responseQry[8] != null){
	        $this->patientName .= $responseQry[8];
	    }
	    if($responseQry[9] != "" && $responseQry[9] != null){
	        $this->patientName .= " " . $responseQry[9];
	    }
	    if($responseQry[10] != "" && $responseQry[10] != null){
	        $this->patientName .= " " . $responseQry[10];
	    }
	    if($responseQry[11] != "" && $responseQry[11] != null){
	        $this->patientName .= " " . $responseQry[11];
	    }
	    $this->patientName .= "*";
        $this->patientFirstName = "*" . $responseQry[8] . "*";
        $this->Exento = $responseQry[12];
        $this->Cliente = $responseQry[13];
        $this->patientEstado = $responseQry[14];
        $this->patientExisteBD = $responseQry[15];
        $this->patientCliente = $responseQry[16];
    }
    
    function getIdChat(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_getidchat("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->Paciente = $responseQry[0];
        $this->patientToId = $responseQry[1];
        $this->patientName = $responseQry[2];
        $this->patientFirstName = "*" . $responseQry[11] . "*";
        $this->Cliente = $responseQry[3];
        $this->patientCliente = $responseQry[4];
        $this->rootId = $responseQry[5];
        @eval($responseQry[6]);
        $this->questionOpt = $botOptions;
        $this->questionNextRoot = $responseQry[7];
        $this->isChild = $responseQry[10];
        $this->txtQuestionOpt = $responseQry[6];
        $this->questionTxt = $responseQry[8];
        $this->questionTxtRpt = $responseQry[9];
        @eval($responseQry[8]);
        $this->questionMsg = $botQuestion;
        @eval($responseQry[9]);
        $this->questionMsgRpt = $botQuestionRpt;
    }
 
    ////////////////////////////////////////////////////////////////////////////////////
    //SET METHOD
    ////////////////////////////////////////////////////////////////////////////////////
    function setConfirmAppointment(){
        if($this->CAS != "" && $this->CAS != null){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asignarcitas_confirmar2102('" . $this->CAS . "',\"" . $this->wsp_id . "\")";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $this->txtBodyToSend = $this->patientFirstName . ", confirmaste la cita *CAS: " . $this->CAS . "*, recuerda asistir el día de la cita *20 minutos antes* de la hora programada."  . PHP_EOL  . PHP_EOL;
            $this->txtBodyToSend .= MSJPIERECUERDACANCELA . PHP_EOL  . PHP_EOL;
            $this->txtBodyToSend .= "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();
        }else{
            $this->txtBodyToSend = "Te pedimos disculpas, en este momento no podemos realizar tu solicitud, por favor intenta nuevamente en unos minutos.";
            $this->sendMsg();
            $this->txtBodyToSend = "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();    
        }
    }
    
    function setCancelAppointment(){
        if($this->CAS != "" && $this->CAS != null){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asignarcitas_cancelar2102('" . $this->CAS . "',\"" . $this->wsp_id . "\")";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $this->txtBodyToSend = $this->patientFirstName . ", cancelaste la cita *CAS: " . $this->CAS . "*."  . PHP_EOL  . PHP_EOL;
            $this->txtBodyToSend .= MSJPIEFELICITACANCELA . PHP_EOL  . PHP_EOL;
            $this->txtBodyToSend .= "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();
        }else{
            $this->txtBodyToSend = "Te pedimos disculpas, en este momento no podemos realizar tu solicitud, por favor intenta nuevamente en unos minutos.";
            $this->sendMsg();
            $this->txtBodyToSend = "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
            $this->sendMsg();
            $this->endChat();    
        }    
    }
    
    ////////////////////////////////////////////////////////////////////////////////////
    //VALIDATE METHOD
    ////////////////////////////////////////////////////////////////////////////////////
    function validateAppointmentExists($tipoCita){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_checkcitaxtipo('" . $this->Paciente . "',\"" . $tipoCita . "\")";
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->appointmentCAS = $responseQry[0];
        $this->appointmentDate = $responseQry[5];
    	$this->appointmentHour = $responseQry[6];
    	$this->appointmentProfesional = $responseQry[1];
    	$this->appointmentConcept = $responseQry[10];
    	$this->appointmentDay = $responseQry[11];
    	if($this->appointmentCAS != "0" && $this->appointmentCAS != null && $this->appointmentCAS != "" && $this->appointmentCAS != "{success:false}"){
    	    $this->isAppointmentExists = 1;
    	}
    }
    
    function validateAbsence(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_checkinasistencia('" . $this->Paciente . "')";
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->appointmentCAS = $responseQry[6];
        $this->appointmentDate = $responseQry[2];
    	$this->appointmentHour = $responseQry[3];
    	$this->appointmentProfesional = $responseQry[7];
    	$this->appointmentConcept = $responseQry[9];
    	if($this->appointmentCAS != "0" && $this->appointmentCAS != null && $this->appointmentCAS != "" && $this->appointmentCAS != "{success:false}"){
    	    $this->isAbsence = 1;
    	}
    }
    
    function validateAnswer(){
        $this->getLastQuestion();
        if(strtoupper($this->answer) == "FIN" || strtoupper($this->answer) == "FINALIZAR" || strtoupper($this->answer) == "AYUDA" || strtoupper($this->answer) == "EMPEZAR" || strtoupper($this->answer) == "HOLA" || strtoupper($this->answer) == "OLA"){
            if($this->patientName != "" && $this->patientName != null && $this->patientName != "{success:false}"){
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requieres hacer otra cita, ingresa con la palabra *Ayuda*.";
                $this->sendMsg();
            }
            $this->endChat();
        }else if($this->rootId != "{success:false}"){
            if($this->rootId == "0"){
                //validar Usuario
                $this->getDataPatient();
                if($this->Paciente != "" && $this->Paciente != "{success:false}"){
                    if($this->patientExisteBD != "OKBD"){
                        $this->rootId = "0";
                        $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", no estas registrado en ninguna de las bases de datos de las EPS con las que tenemos convenio, te invitamos a que te comunique con tu EPS y lo intentes posteriormente.";
                        $this->endChat();
                        $this->sendMsg();
                    }else{
                        if($this->patientEstado != "ACTIVO"){
                            $this->rootId = "0";
                            $this->txtBodyToSend = $this->patientToId . " " . $this->patientName . ", no estas *ACTIVO* en la última base de datos de *" . $this->patientCliente . "*, te invitamos a que te comuniques con tu EPS y lo intentes posteriormente.";
                            $this->endChat();
                            $this->sendMsg();
                        }else{
                            if($this->WSPValido == "SI"){
                                $this->patientBeginChat = "1";
                                $this->rootId = "1";
                                $this->callMenuOptions("N");
                                $this->sendQuestion();
                            }else{
                                $this->rootId = "0";
                                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", aún no has registrado este número de contacto como canal de comunicación, te invitamos a que te registres en nuestra página: www.medicareips.com.co/registrowsp";
                                $this->endChat();
                                $this->sendMsg();
                            }
                        }
                    }
                }else{
                    $this->txtBodyToSend = "El *Documento* *" . $this->answer . "* no existe en nuestra base de datos, por favor verifica esta información.";
                    $this->endChat();
                    $this->sendMsg();
                }
            }
        }
    }
    
    function validateBeginChat(){
        $this->isBeginChat = "0";
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_360dialog_validate_beginchat("' . $this->wsp_id . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $this->isBeginChat = $responseQry[0];
    }
    
    function validateAnswerOptionMenu(){
        $this->seloptionId = "0";
        $this->seloptionTitle = "";
        $this->seloptionFunction = "";
        $this->seloptionNextRoot = "";
        $arrIterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($this->questionOpt),RecursiveIteratorIterator::SELF_FIRST);
        $Root = "";
        $Context = "0";
        $item = 0;
        foreach ($arrIterator as $key => $val) {
            if(is_array($val)) {
                if($key != "0"){
                    $item = $key;
                }
            }else{
                if($item == strtoupper($this->answer)){
                    if($key == "opcion"){
                        $this->seloptionId = $val;
                    }else if($key == "titulo"){
                        $this->seloptionTitle = $val;
                    }else if($key == "funcion"){
                        $this->seloptionFunction = $val;
                    }else if($key == "next"){
                        $this->seloptionNextRoot = $val;
                    }else if($key == "CAS"){
                        $this->CAS = $val;
                    }
                }
            }
        }
        if($this->seloptionId == "0"){
            $this->txtBodyToSend = $this->patientFirstName . ", tu respuesta no es correcta por favor verifícala nuevamente.";
            $this->sendMsg();
            if($this->isChild == "1"){
                $this->sendQuestionChild();
            }else{
                $this->callMenuOptions("Y");
                $this->sendQuestion();
            }
        }else{
            if($this->seloptionFunction != "" && $this->seloptionFunction != null && $this->seloptionFunction != "{success:false}"){
                switch($this->seloptionFunction){
                    case "getCitasMedicina":
                        $this->getCitasMedicina();
                        break;
                    case "getConfirmAppointment":
                        $this->getConfirmAppointment();
                        break;
                    case "getCancelAppointment":
                        $this->getCancelAppointment();
                        break;
                    case "setConfirmAppointment":
                        $this->setConfirmAppointment();
                        break;
                    case "setCancelAppointment":
                        $this->setCancelAppointment();
                        break;
                    default:
                        $this->txtBodyToSend = "Seleccionaste " . $this->seloptionId . " - " . $this->seloptionTitle . " - Sgte: " . $this->seloptionNextRoot;
                        $this->sendMsg();
                        break;
                }
            }else{
                $this->rootId = $this->seloptionNextRoot;
                $this->callMenuOptions("N");
                $this->sendQuestion();
            }
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////
    //OTHERS METHOD
    ////////////////////////////////////////////////////////////////////////////////////
    function showAppointment($existe){
        $this->rootId = "0";
        $this->txtBodyToSend = "";
        if($existe == "SI"){
            $this->txtBodyToSend = $this->patientToId . " " . $this->patientName . ", tienes una *CITA ASIGNADA* resgistrada en nuestro sistema, si deseas otra cita te invitamos a cancelar primero la siguiente cita:" . PHP_EOL . PHP_EOL;
        }else{
            $this->txtBodyToSend = $this->patientToId . " " . $this->patientName . ", felicidades *SE ASIGNO UNA CITA*, te invitamos a revisar la siguiente información:" . PHP_EOL . PHP_EOL;
        }
        $this->txtBodyToSend .= "*Fecha*: " . $this->appointmentDate . "- *Hora*: " . $this->appointmentHour . PHP_EOL;
        if($existe == "SI"){
            $this->txtBodyToSend .= "*Día de la Cita*: " . $this->appointmentDay . PHP_EOL;
        }
        $this->txtBodyToSend .= "*Profesional*: " . $this->appointmentProfesional . PHP_EOL;
        $this->txtBodyToSend .= "*Concepto*: " . $this->appointmentConcept . PHP_EOL;
        $this->txtBodyToSend .= "*CAS*: " . $this->appointmentCAS . PHP_EOL . PHP_EOL;
        $this->txtBodyToSend .= "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
        $this->sendMsg();
        $this->endChat();
    }
    
    function showAbsence(){
        $this->rootId = "0";
        $this->txtBodyToSend = $this->patientToId . " " . $this->patientName . ", tienes una *INASISTENCIA* resgistrada en nuestro sistema, te invitamos a realizar el proceso de legalización, a continuación encontraras la información detallada:" . PHP_EOL . PHP_EOL;
        $this->txtBodyToSend .= "*Fecha*: " . $this->appointmentDate . "- *Hora*: " . $this->appointmentHour . PHP_EOL;
        $this->txtBodyToSend .= "*Profesional*: " . $this->appointmentProfesional . PHP_EOL;
        $this->txtBodyToSend .= "*Concepto*: " . $this->appointmentConcept . PHP_EOL;
        $this->txtBodyToSend .= "*CAS*: " . $this->appointmentCAS . PHP_EOL . PHP_EOL;
        $this->txtBodyToSend .= "Gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto. Si quieres hacer otra consulta ingresa con la palabra *Ayuda*.";
        $this->sendMsg();
        $this->endChat();
    }
    
    function goFlowProcess(){
        $this->getIdChat();
        switch(strtoupper($this->answer)){
            case "0":
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requieres hacer otra cita, ingresa con la palabra *Ayuda*.";
                $this->sendMsg();
                $this->endChat();
                break;
            case "O":
                $this->txtBodyToSend = $this->patientToId . " ". $this->patientName . ", gracias por usar el ChatBot de " . NOMIPSCHAT . ", te esperamos pronto." .  PHP_EOL .  PHP_EOL . "Si requieres hacer otra cita, ingresa con la palabra *Ayuda*.";
                $this->sendMsg();
                $this->endChat();
                break;
            default:
                $this->validateAnswerOptionMenu();
                break;
        }
    }
    
    function saveRootOptions(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_set_root_flow("' . $this->wsp_id . '","' . $this->rootId . '","' . $this->txtQuestionOpt . '","' . $this->questionTxt . '","' . $this->questionTxtRpt . '")';
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
    }
    
    function saveRootOptionsMasterId(){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_set_root("' . $this->wsp_id . '","' . $this->rootId . '","' . $this->txtQuestionOpt . '")';
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
    }
    
    function callMenuOptions($opt){
        //extract menu options from database
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_get_root("' . $this->rootId . '")';
        $responseQry = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $botQuestion = "";
        $botOptions = "";
        if($opt == "Y"){
            @eval($responseQry[3]);
        }else{
            @eval($responseQry[1]);
        }
        @eval($responseQry[2]);
        $this->questionMsg = $botQuestion;
        $this->questionOpt = $botOptions;
    }
    
    function sendQuestion(){
        $this->txtBodyToSend = $this->questionMsg;
        $envio = $this->sendMsg();
        $this->Request = $envio;
        //Save question and root
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'CALL sp_whatsappbot_save_question("' . $this->wsp_id . '","' . $this->rootId . '",\'' . $this->Paciente . '\',"' . $this->patientName . '",\'' . $this->Cliente . '\',"' . $this->patientCliente . '","' . $this->patientToId . '")';
		@mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar(); 
        return $this->Request;
    }
    
    function sendQuestionChild(){
        $this->txtBodyToSend = $this->questionMsgRpt;
        $envio = $this->sendMsg();
        $this->Request = $envio;
        return $this->Request;
    }
    
    function writeLog($text){
        $file = fopen("log.txt", "a");
        fwrite($file, date('h:i:s A') . " - " . $text . PHP_EOL);
        fwrite($file, "----------------------------------------------" . PHP_EOL);
        fclose($file);
    }
}